@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.trade.bot.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <dl class="row">
                    <dt class="col-sm-4">Name</dt>
                    <dd class="col-sm-8">{{ $tradeBot->name }}</dd>

                    <dt class="col-sm-4">Minimum</dt>
                    <dd class="col-sm-8">{{ $tradeBot->minimum }}</dd>

                    <dt class="col-sm-4">Maximum</dt>
                    <dd class="col-sm-8">{{ $tradeBot->maximum }}</dd>

                    <dt class="col-sm-4">Currency</dt>
                    <dd class="col-sm-8">{{ $tradeBot->currency->name() }}</dd>

                    <dt class="col-sm-4">Asset Pairs</dt>
                    <dd class="col-sm-8">
                        {{ $market->where('id', $tradeBot->asset_pairs)->first()->asset }}
                    </dd>

                    @if ($tradeBot->features)
                        <dt class="col-sm-4">Features</dt>
                        <dd class="col-sm-8">
                            <ul>
                                @foreach ($tradeBot->features as $feature)
                                    <li>{{ ucwords(str_replace('_', ' ', $feature)) }}</li>
                                @endforeach
                            </ul>
                        </dd>
                    @endif

                    @if ($tradeBot->parameters)
                        <dt class="col-sm-4">Parameters</dt>
                        <dd class="col-sm-8">
                            <ul>
                                @foreach ($tradeBot->parameters as $parameter)
                                    <li>{{ ucwords(str_replace('_', ' ', $parameter)) }}</li>
                                @endforeach
                            </ul>
                        </dd>
                    @endif

                    @if ($tradeBot->description)
                        <dt class="col-sm-4">Description</dt>
                        <dd class="col-sm-8">{{ $tradeBot->description }}</dd>
                    @endif

                </dl>

                <a href="{{ route('admin.trade.bot.show', $tradeBot->uuid) }}" class="btn btn-info btn-sm m-1">
                    <i class="fa fa-file-text me-1"></i> View
                </a>

                <a href="{{ route('admin.trade.bot.edit', $tradeBot->uuid) }}" class="btn btn-primary btn-sm m-1">
                    <i class="fa fa-edit me-1"></i> Edit
                </a>

                <form action="{{ route('admin.trade.bot.delete', $tradeBot->uuid) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-sm m-1"
                        onclick="return confirm('Are you sure you want to delete this trade bot?')">
                        <i class="fa fa-trash me-1"></i>Delete
                    </button>
                </form>

            </x-dashboard.card>
        </div>

    </div>
@endsection
