@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.trade.bot.create'),
                'text' => 'Add New Trade Bot',
                'icon' => 'fa fa-plus me-1',
            ]">

                <div class="table-responsive">
                    <table id="myTable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Asset Pairs</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($tradeBots as $tradeBot)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        {{ $tradeBot->name }}
                                    </td>
                                    <td>
                                        {{ $market->where('id', $tradeBot->asset_pairs)->first()->asset }}
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.trade.bot.show', $tradeBot->uuid) }}"
                                            class="btn btn-info btn-sm m-1">
                                            <i class="fa fa-file-text me-1"></i> View
                                        </a>

                                        <a href="{{ route('admin.trade.bot.edit', $tradeBot->uuid) }}"
                                            class="btn btn-primary btn-sm m-1">
                                            <i class="fa fa-edit me-1"></i> Edit
                                        </a>

                                        <form action="{{ route('admin.trade.bot.delete', $tradeBot->uuid) }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm m-1"
                                                onclick="return confirm('Are you sure you want to delete this trade bot?')">
                                                <i class="fa fa-trash me-1"></i>Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </x-dashboard.card>
        </div>

    </div>
@endsection
