@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.trade.bot.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <form action="{{ route('admin.trade.bot.store') }}" method="post">
                    @csrf

                    <div class="row">
                        <x-dashboard.form-input name="name" label="Name" class="col-md-12 mb-3"
                            value="{{ old('name') }}" required />

                        <x-dashboard.form-input name="minimum" label="Minimum" class="col-md-6 mb-3"
                            value="{{ old('minimum') }}" type="number" required />

                        <x-dashboard.form-input name="maximum" label="Maximum" class="col-md-6 mb-3"
                            value="{{ old('maximum') }}" type="number" required />

                        <!-- Currencies -->
                        <div class="col-md-6 mb-3">
                            <label for="currency" class="form-label fw-semibold">Currencies</label>
                            <select name="currency" id="currency"
                                class="form-select @error('currency') is-invalid @enderror" required>
                                <option value="">Select</option>
                                @foreach ($currencies as $currency)
                                    <option value="{{ $currency->value }}"
                                        {{ old('currency') == $currency->value ? 'selected' : '' }}>
                                        {{ $currency->name() }}</option>
                                @endforeach
                            </select>
                            @error('currency')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Asset Pairs -->
                        <div class="col-md-6 mb-3">
                            <label for="asset_pairs" class="form-label fw-semibold">Market/Asset Pairs</label>
                            <select name="asset_pairs[]" id="asset_pairs" required
                                class="form-select @error('asset_pairs') is-invalid @enderror">
                                <option value="">Select</option>
                                @foreach ($markets as $market)
                                    <option value="{{ $market->id }}"
                                        {{ old('asset_pairs') == $market->id ? 'selected' : '' }}>
                                        {{ $market->asset }}</option>
                                @endforeach
                            </select>
                            @error('asset_pairs')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <x-dashboard.form-input name="features[]" label="Features" class="col-md-6 mb-3" required
                            value="{{ old('features', 'stop_loss, take_profit, trailing_stop_loss, high_frequency') }}"
                            type="textarea" />

                        <x-dashboard.form-input name="parameters[]" label="Parameters" class="col-md-6 mb-3" required
                            value="{{ old('parameters', 'timeframe: 5m, risk_percent: 2, rsi_buy: 30, rsi_sell: 70') }}"
                            placeholder="timeframe: 5m, risk_percent: 2, rsi_buy: 30, rsi_sell: 70" type="textarea" />

                        <x-dashboard.form-input name="description" label="Description" class="col-md-12 mb-3"
                            value="{{ old('description') }}" type="textarea" />

                    </div>

                    <x-dashboard.form-button />

                </form>

            </x-dashboard.card>
        </div>

    </div>
@endsection
