@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}">

                <form action="{{ route('admin.profile.store') }}" method="post">
                    @csrf
                    @method('PATCH')

                    <div class="row">
                        <!-- Name -->
                        <div class="col-md-12 mb-3">
                            <label class="form-label">Name</label>
                            <input type="text" name="name" value="{{ old('name', $user->name) }}"
                                class="form-control @error('name') is-invalid @enderror" placeholder="Enter your name"
                                required>
                            @error('name')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Email -->
                        <div class="col-md-12 mb-3">
                            <label class="form-label">Email</label>
                            <input type="text" value="{{ $user->email }}" readonly class="form-control">
                        </div>

                        <!-- Status -->
                        <div class="col-md-12 mb-3">
                            <label class="form-label">Status</label>
                            <input type="text" value="{{ strtoupper($user->status->value) }}" readonly
                                class="form-control">
                        </div>

                    </div>

                    <x-dashboard.form-button />
                </form>

            </x-dashboard.card>
        </div>

    </div>
@endsection
