@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.newsletter.subscriber.create'),
                'text' => 'Send Newsletter',
                'icon' => 'ti ti-mail me-1',
            ]">

                <div class="table-responsive">
                    <table id="myTable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Email</th>
                                <th>Subscribed At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($newsletterSubscribers as $newsletterSubscriber)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $newsletterSubscriber->email }}</td>
                                    <td>{{ formatDateTime($newsletterSubscriber->subscribed_at) }}</td>
                                    <td>
                                        <form
                                            action="{{ route('admin.newsletter.subscriber.delete', $newsletterSubscriber->uuid) }}"
                                            method="POST" class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm m-1"
                                                onclick="return confirm('Are you sure you want to delete this newsletter subscriber?')">
                                                <i class="fa fa-trash me-1"></i>Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                @if (!$newsletterSubscribers->isEmpty())
                    <x-slot name="footer">
                        <form action="{{ route('admin.newsletter.subscriber.delete_all') }}" method="POST"
                            class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-sm m-1"
                                onclick="return confirm('Are you sure you want to delete this all newsletter subscriber?')">
                                <i class="fa fa-trash me-1"></i>Delete All
                            </button>
                        </form>
                    </x-slot>
                @endif
            </x-dashboard.card>
        </div>

    </div>
@endsection
