@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.newsletter.subscriber.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <form action="{{ route('admin.newsletter.subscriber.store') }}" method="post">
                    @csrf

                    <div class="row">
                        <x-dashboard.form-input name="subject" label="Subject" class="col-md-12 mb-3"
                            value="{{ old('subject') }}" placeholder="Enter your subject" required />

                        <div class="col-md-12 mb-3">
                            <label for="newsletter-content" class="form-label">Content</label>

                            <textarea name="content" id="newsletter-content" class="form-control tinyMCE" rows="12"
                                placeholder="Enter your content" required>{{ old('content') }}</textarea>

                            <x-dashboard.input-error name="content" />
                        </div>

                    </div>

                    <x-dashboard.form-button />

                </form>

            </x-dashboard.card>
        </div>

    </div>
@endsection
