@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.market.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <dl class="row">

                    <dt class="col-sm-3">Asset</dt>
                    <dd class="col-sm-9">{{ $market->asset }}</dd>

                    <dt class="col-sm-3">Rate</dt>
                    <dd class="col-sm-9">{{ $market->rate }}</dd>

                    <dt class="col-sm-3">Price</dt>
                    <dd class="col-sm-9">{{ formatAmount($market->price) }}</dd>

                    <dt class="col-sm-3">High</dt>
                    <dd class="col-sm-9">{{ $market->high }}</dd>

                    <dt class="col-sm-3">Low</dt>
                    <dd class="col-sm-9">{{ $market->low }}</dd>

                    <dt class="col-sm-3">Volume</dt>
                    <dd class="col-sm-9">{{ $market->volume }}</dd>

                </dl>

                <div class="d-flex gap-2">
                    <a href="{{ route('admin.market.show', $market->uuid) }}" class="btn btn-info btn-sm m-1">
                        <i class="fa fa-file-text me-1"></i> View
                    </a>

                    <a href="{{ route('admin.market.edit', $market->uuid) }}" class="btn btn-primary btn-sm m-1">
                        <i class="fa fa-edit me-1"></i> Edit
                    </a>

                    <form action="{{ route('admin.market.delete', $market->uuid) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm m-1"
                            onclick="return confirm('Are you sure you want to delete this market?')">
                            <i class="fa fa-trash me-1"></i>Delete
                        </button>
                    </form>
                </div>

            </x-dashboard.card>
        </div>

    </div>
@endsection
