@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.market.create'),
                'text' => 'Add New Market',
                'icon' => 'fa fa-plus me-1',
            ]">

                <div class="table-responsive d-none d-md-block">
                    <table id="myTable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Asset</th>
                                <th>Rate</th>
                                <th>Price</th>
                                <th>High</th>
                                <th>Low</th>
                                <th>Volume</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($markets as $market)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $market->asset }}</td>
                                    <td>{{ $market->rate }}</td>
                                    <td>{{ formatAmount($market->price) }}</td>
                                    <td>{{ $market->high }}</td>
                                    <td>{{ $market->low }}</td>
                                    <td>{{ $market->volume }}</td>
                                    <td>
                                        <a href="{{ route('admin.market.show', $market->uuid) }}"
                                            class="btn btn-info btn-sm m-1">
                                            <i class="fa fa-file-text me-1"></i> View
                                        </a>

                                        <a href="{{ route('admin.market.edit', $market->uuid) }}"
                                            class="btn btn-primary btn-sm m-1">
                                            <i class="fa fa-edit me-1"></i> Edit
                                        </a>

                                        <form action="{{ route('admin.market.delete', $market->uuid) }}" method="POST"
                                            class="d-inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm m-1"
                                                onclick="return confirm('Are you sure you want to delete this market?')">
                                                <i class="fa fa-trash me-1"></i>Delete
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="d-block d-md-none">
                    @foreach ($markets as $market)
                        <div class="card mb-3 shadow-sm">
                            <div class="card-body">
                                <h5 class="card-title"><strong>Asset:</strong>
                                    {{ $market->asset }}
                                </h5>

                                <p class="mb-1"><strong>Rate:</strong> {{ $market->rate }}</p>
                                <p class="mb-1"><strong>Price:</strong> {{ formatAmount($market->price) }}</p>
                                <p class="mb-1"><strong>High:</strong> {{ $market->high }}</p>
                                <p class="mb-1"><strong>Low:</strong> {{ $market->low }}</p>
                                <p class="mb-2"><strong>Volume:</strong> {{ $market->volume }}</p>

                                <div class="d-flex gap-2">
                                    <a href="{{ route('admin.market.show', $market->uuid) }}"
                                        class="btn btn-info btn-sm m-1">
                                        <i class="fa fa-file-text me-1"></i> View
                                    </a>

                                    <a href="{{ route('admin.market.edit', $market->uuid) }}"
                                        class="btn btn-primary btn-sm m-1">
                                        <i class="fa fa-edit me-1"></i> Edit
                                    </a>

                                    <form action="{{ route('admin.market.delete', $market->uuid) }}" method="POST"
                                        class="d-inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm m-1"
                                            onclick="return confirm('Are you sure you want to delete this market?')">
                                            <i class="fa fa-trash me-1"></i>Delete
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

            </x-dashboard.card>
        </div>

    </div>
@endsection
