@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.market.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <form action="{{ route('admin.market.update', $market->uuid) }}" method="post">
                    @csrf
                    @method('PATCH')

                    <div class="row">

                        <x-dashboard.form-input name="asset" label="Asset" class="col-md-6 mb-3"
                            value="{{ old('asset', $market->asset) }}" placeholder="1INCH / USDT" required />

                        <x-dashboard.form-input name="rate" label="Rate" class="col-md-6 mb-3"
                            value="{{ old('rate', $market->rate) }}" type="number" required />

                        <x-dashboard.form-input name="price" label="Price" class="col-md-6 mb-3"
                            value="{{ old('price', $market->price) }}" type="number" required />

                        <x-dashboard.form-input name="high" label="High" class="col-md-6 mb-3"
                            value="{{ old('high', $market->high) }}" type="number" required />

                        <x-dashboard.form-input name="low" label="Low" class="col-md-6 mb-3"
                            value="{{ old('low', $market->low) }}" type="number" required />

                        <x-dashboard.form-input name="volume" label="Volume" class="col-md-6 mb-3"
                            value="{{ old('volume', $market->volume) }}" type="number" required />

                    </div>

                    <x-dashboard.form-button />

                </form>

            </x-dashboard.card>
        </div>

    </div>
@endsection
