@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <div class="card shadow-sm">
                    <div class="card-header">
                        <h5 class="mb-0">Request Details</h5>
                    </div>
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <h6 class="text-muted mb-2">User Information</h6>
                                <p class="mb-1"><strong>Name:</strong> 
                                    <a href="{{ route('admin.user.show', $isolatedMarginRequest->user->uuid) }}" target="_blank">
                                        {{ $isolatedMarginRequest->user->name }}
                                    </a>
                                </p>
                                <p class="mb-1"><strong>Email:</strong> {{ $isolatedMarginRequest->user->email }}</p>
                                <p class="mb-1"><strong>Phone:</strong> {{ $isolatedMarginRequest->user->phone ?? 'N/A' }}</p>
                                <p class="mb-1"><strong>Currency:</strong> {{ $isolatedMarginRequest->user->currency }}</p>
                            </div>
                            <div class="col-md-6">
                                <h6 class="text-muted mb-2">Request Information</h6>
                                <p class="mb-1"><strong>Amount:</strong> {{ currency($isolatedMarginRequest->user->currency) . formatAmount($isolatedMarginRequest->amount) }}</p>
                                <p class="mb-1"><strong>Payment Method:</strong> 
                                    @if ($isolatedMarginRequest->wallet)
                                        {{ $isolatedMarginRequest->wallet->name }} ({{ $isolatedMarginRequest->wallet->network }})
                                    @else
                                        <span class="text-muted">N/A</span>
                                    @endif
                                </p>
                                <p class="mb-1"><strong>Requested:</strong> {{ $isolatedMarginRequest->created_at->format('F j, Y g:i A') }}</p>
                                <p class="mb-1">
                                    <strong>Status:</strong>
                                    <span class="{{ $isolatedMarginRequest->status->badge() }}">{{ $isolatedMarginRequest->status->label() }}</span>
                                </p>
                            </div>
                        </div>

                        <hr>

                        <!-- Payment Proof -->
                        @if ($isolatedMarginRequest->proof)
                            <div class="mb-4">
                                <h6 class="text-muted mb-2">Payment Proof</h6>
                                <div class="mb-3">
                                    <img src="{{ asset($isolatedMarginRequest->proof) }}" alt="Payment Proof"
                                        class="img-fluid rounded border" style="max-height: 400px;">
                                </div>
                            </div>

                            <hr>
                        @endif

                        <div class="row">
                            <div class="col-md-6">
                                @if ($isolatedMarginRequest->reviewed_at)
                                    <p class="mb-1"><strong>Reviewed At:</strong> {{ $isolatedMarginRequest->reviewed_at->format('F j, Y g:i A') }}</p>
                                @endif
                            </div>
                            <div class="col-md-6">
                                @if ($isolatedMarginRequest->admin_note)
                                    <p class="mb-1"><strong>Admin Note:</strong></p>
                                    <div class="alert alert-secondary">
                                        {{ $isolatedMarginRequest->admin_note }}
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                @if ($isolatedMarginRequest->isPending())
                    <div class="card shadow-sm">
                        <div class="card-header">
                            <h5 class="mb-0">Take Action</h5>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.isolated_margin_request.update', $isolatedMarginRequest->uuid) }}" method="POST">
                                @csrf
                                @method('PUT')

                                <div class="mb-3">
                                    <label for="decision" class="form-label">Decision <span class="text-danger">*</span></label>
                                    <select name="status" id="decision" class="form-select @error('status') is-invalid @enderror" required>
                                        <option value="">Select Decision</option>
                                        @foreach ($statuses as $status)
                                            @if ($status->value != 'pending')
                                                <option value="{{ $status->value }}">{{ $status->label() }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="admin_note" class="form-label">Note (Optional)</label>
                                    <textarea name="admin_note" id="admin_note" class="form-control @error('admin_note') is-invalid @enderror" rows="3" placeholder="Add a note...">{{ old('admin_note') }}</textarea>
                                    <small class="text-muted">Max 500 characters</small>
                                    @error('admin_note')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="d-grid">
                                    <button type="submit" class="btn btn-primary" onclick="return confirm('Are you sure you want to submit this decision?')">
                                        Submit Decision
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                @else
                    <div class="card shadow-sm">
                        <div class="card-body text-center py-4">
                            <i class="ti ti-check fs-1 text-{{ $isolatedMarginRequest->isApproved() ? 'success' : 'danger' }} mb-2"></i>
                            <h5>Request {{ $isolatedMarginRequest->status->label() }}</h5>
                            <p class="text-muted mb-2">
                                Reviewed on {{ $isolatedMarginRequest->reviewed_at->format('F j, Y g:i A') }}
                            </p>
                            @if ($isolatedMarginRequest->admin_note)
                                <div class="mt-3 text-start">
                                    <small class="text-muted"><strong>Note:</strong></small>
                                    <div class="alert alert-secondary alert-sm mt-2">
                                        {{ $isolatedMarginRequest->admin_note }}
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif

                <!-- Quick Info -->
                <div class="card shadow-sm mt-3">
                    <div class="card-body">
                        <h6 class="fw-semibold mb-2">
                            <i class="ti ti-info-circle me-2"></i>Quick Info
                        </h6>
                        <div class="text-muted small">
                            <p class="mb-2">
                                <strong>Status:</strong><br>
                                {{ $isolatedMarginRequest->status->label() }}
                            </p>
                            <p class="mb-2">
                                <strong>Amount:</strong><br>
                                {{ currency($isolatedMarginRequest->user->currency) . formatAmount($isolatedMarginRequest->amount) }}
                            </p>
                            <p class="mb-0">
                                <strong>Request ID:</strong><br>
                                <code>{{ $isolatedMarginRequest->uuid }}</code>
                            </p>
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </div>
@endsection
