@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <div class="card shadow-sm">
                    <div class="card-header">
                        <h5 class="mb-0">Request Details</h5>
                    </div>
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <h6 class="text-muted mb-2">User Information</h6>
                                <p class="mb-1"><strong>Name:</strong> {{ $copyTradeRequest->user->name }}</p>
                                <p class="mb-1"><strong>Email:</strong> {{ $copyTradeRequest->user->email }}</p>
                                <p class="mb-1"><strong>Phone:</strong> {{ $copyTradeRequest->user->phone ?? 'N/A' }}</p>
                                <p class="mb-1">
                                    <strong>Wallet:</strong>
                                    @if ($copyTradeRequest->user->wallet_address)
                                        <code>{{ $copyTradeRequest->user->wallet_address }}</code>
                                    @else
                                        <span class="text-muted">Not connected</span>
                                    @endif
                                </p>
                            </div>
                            <div class="col-md-6">
                                <h6 class="text-muted mb-2">Trader Information</h6>
                                <p class="mb-1"><strong>Name:</strong> {{ $copyTradeRequest->trader->user->name }}</p>
                                <p class="mb-1"><strong>UUID:</strong> <code>{{ $copyTradeRequest->trader->uuid }}</code></p>
                                <p class="mb-1"><strong>Balance:</strong> {{ currency($copyTradeRequest->trader->user->currency) . formatAmount($copyTradeRequest->trader->balance) }}</p>
                                <p class="mb-1"><strong>Status:</strong> <span class="{{ $copyTradeRequest->trader->status->badge() }}">{{ $copyTradeRequest->trader->status->label() }}</span></p>
                            </div>
                        </div>

                        <hr>

                        <div class="row">
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Request Date:</strong> {{ $copyTradeRequest->created_at->format('F j, Y g:i A') }}</p>
                                <p class="mb-1">
                                    <strong>Current Status:</strong>
                                    <span class="{{ $copyTradeRequest->status->badge() }}">{{ $copyTradeRequest->status->label() }}</span>
                                </p>
                            </div>
                            <div class="col-md-6">
                                @if ($copyTradeRequest->reviewed_at)
                                    <p class="mb-1"><strong>Reviewed At:</strong> {{ $copyTradeRequest->reviewed_at->format('F j, Y g:i A') }}</p>
                                @endif
                                @if ($copyTradeRequest->admin_note)
                                    <p class="mb-1"><strong>Admin Note:</strong> {{ $copyTradeRequest->admin_note }}</p>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                @if ($copyTradeRequest->isPending())
                    <div class="card shadow-sm">
                        <div class="card-header">
                            <h5 class="mb-0">Take Action</h5>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.copy.trade.request.update', $copyTradeRequest->uuid) }}" method="POST">
                                @csrf
                                @method('PUT')

                                <div class="mb-3">
                                    <label for="example-select" class="form-label">Decision <span class="text-danger">*</span></label>
                                    <select name="status" id="example-select" class="form-select @error('status') is-invalid @enderror" required>
                                        <option value="">Select Decision</option>
                                        @foreach ($statuses as $status)
                                            @if ($status->value != 'pending')
                                                <option value="{{ $status->value }}">{{ $status->label() }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="admin_note" class="form-label">Note (Optional)</label>
                                    <textarea name="admin_note" id="admin_note" class="form-control @error('admin_note') is-invalid @enderror" rows="3" placeholder="Add a note...">{{ old('admin_note') }}</textarea>
                                    @error('admin_note')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="d-grid">
                                    <button type="submit" class="btn btn-primary" onclick="return confirm('Are you sure you want to submit this decision?')">
                                        Submit Decision
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                @else
                    <div class="card shadow-sm">
                        <div class="card-body text-center py-4">
                            <i class="ti ti-check fs-1 text-{{ $copyTradeRequest->isApproved() ? 'success' : 'danger' }} mb-2"></i>
                            <h5>Request {{ $copyTradeRequest->status->label() }}</h5>
                            <p class="text-muted mb-0">This request has already been reviewed.</p>
                        </div>
                    </div>
                @endif

                <div class="mt-3">
                    <a href="{{ route('admin.copy.trade.request.index') }}" class="btn btn-outline-secondary w-100">
                        <i class="fa fa-arrow-left me-1"></i> Back to Requests
                    </a>
                </div>
            </div>
        </div>

    </div>
@endsection
