@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}">

                <!-- Filter -->
                <div class="mb-3">
                    <form action="{{ route('admin.copy.trade.request.index') }}" method="GET" class="row g-2">
                        <div class="col-md-3">
                            <select name="status" class="form-select">
                                <option value="">All Status</option>
                                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending
                                </option>
                                <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved
                                </option>
                                <option value="declined" {{ request('status') == 'declined' ? 'selected' : '' }}>Declined
                                </option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button type="submit" class="btn btn-primary">Filter</button>
                        </div>
                    </form>
                </div>

                <div class="table-responsive d-none d-md-block">
                    <table id="myTable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>User</th>
                                <th>Trader</th>
                                <th>Status</th>
                                <th>Date</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($requests as $request)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>
                                        {{ $request->user->name }}<br>
                                        <small class="text-muted">{{ $request->user->email }}</small>
                                    </td>
                                    <td>
                                        {{ $request->trader->user->name }}<br>
                                        <small class="text-muted">{{ $request->trader->uuid }}</small>
                                    </td>
                                    <td>
                                        <span
                                            class="{{ $request->status->badge() }}">{{ $request->status->label() }}</span>
                                    </td>
                                    <td>{{ $request->created_at->format('M d, Y H:i') }}</td>
                                    <td>
                                        <a href="{{ route('admin.copy.trade.request.show', $request->uuid) }}"
                                            class="btn btn-info btn-sm m-1">
                                            <i class="fa fa-file-text me-1"></i> View
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="d-block d-md-none">
                    @forelse ($requests as $request)
                        <div class="card mb-3 shadow-sm">
                            <div class="card-body">
                                <h5 class="card-title">
                                    <strong>User:</strong> {{ $request->user->name }}
                                </h5>
                                <p class="mb-1"><strong>Trader:</strong> {{ $request->trader->user->name }}</p>
                                <p class="mb-1">
                                    <strong>Status:</strong>
                                    <span class="{{ $request->status->badge() }}">{{ $request->status->label() }}</span>
                                </p>
                                <p class="mb-2"><strong>Date:</strong> {{ $request->created_at->format('M d, Y') }}</p>
                                <a href="{{ route('admin.copy.trade.request.show', $request->uuid) }}"
                                    class="btn btn-info btn-sm">
                                    <i class="fa fa-file-text me-1"></i> View
                                </a>
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-4 text-muted">
                            No copy trade requests found.
                        </div>
                    @endforelse
                </div>

                {{ $requests->links() }}

            </x-dashboard.card>
        </div>

    </div>
@endsection
