@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <x-dashboard.card title="{{ $title }}" :button="[
                    'route' => route('admin.copy.trade.plan.index'),
                    'text' => 'Back',
                    'icon' => 'fa fa-arrow-left me-1',
                ]">

                    <div class="table-responsive">
                        <table class="table table-borderless">
                            <tbody>
                                <tr>
                                    <td class="fw-semibold">Plan Name:</td>
                                    <td>{{ $copyTradePlan->name }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Type:</td>
                                    <td>{{ $copyTradePlan->type->label() }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Minimum:</td>
                                    <td>{{ formatAmount($copyTradePlan->minimum) }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Maximum:</td>
                                    <td>{{ formatAmount($copyTradePlan->maximum) }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Daily Profit (%):</td>
                                    <td>{{ $copyTradePlan->daily_profit }}%</td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Commission (%):</td>
                                    <td>{{ $copyTradePlan->commission_percentage }}%</td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Trades Per Day:</td>
                                    <td>{{ $copyTradePlan->trades_per_day }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Daily Profit Duration:</td>
                                    <td>{{ $copyTradePlan->daily_profit_duration }} days</td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Daily Profit Multiplication:</td>
                                    <td>{{ $copyTradePlan->daily_profit_multiplication }}x</td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Features:</td>
                                    <td>
                                        @foreach ($copyTradePlan->features as $feature)
                                            <span class="badge bg-primary me-2">{{ $feature }}</span>
                                        @endforeach
                                    </td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Created:</td>
                                    <td>{{ $copyTradePlan->created_at->format('M d, Y H:i') }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Updated:</td>
                                    <td>{{ $copyTradePlan->updated_at->format('M d, Y H:i') }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                </x-dashboard.card>
            </div>

            <div class="col-lg-4">
                <x-dashboard.card title="Actions">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.copy.trade.plan.edit', $copyTradePlan->uuid) }}" class="btn btn-primary">
                            <i class="fa fa-edit me-2"></i> Edit Plan
                        </a>

                        <form action="{{ route('admin.copy.trade.plan.delete', $copyTradePlan->uuid) }}" method="POST">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger w-100"
                                onclick="return confirm('Are you sure you want to delete this plan?')">
                                <i class="fa fa-trash me-2"></i>Delete Plan
                            </button>
                        </form>
                    </div>
                </x-dashboard.card>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-12">
                <x-dashboard.card title="Subscribers">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Invested Amount</th>
                                    <th>Unrealized Profit</th>
                                    <th>Status</th>
                                    <th>Date Subscribed</th>
                                    <th class="text-end">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($subscribers as $subscriber)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <span
                                                    class="avatar avatar-sm me-2 rounded-circle bg-primary-subtle text-primary fw-bold">
                                                    {{ substr($subscriber->user->name, 0, 1) }}
                                                </span>
                                                <div>
                                                    <h6 class="mb-0 text-sm">{{ $subscriber->user->name }}</h6>
                                                    <span class="text-xs text-muted">{{ $subscriber->user->email }}</span>
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ currency($subscriber->user->currency) }}{{ formatAmount($subscriber->amount) }}
                                        </td>
                                        <td>
                                            <span
                                                class="{{ $subscriber->unrealized_profit >= 0 ? 'text-success' : 'text-danger' }} fw-bold">
                                                {{ $subscriber->unrealized_profit >= 0 ? '+' : '' }}{{ currency($subscriber->user->currency) }}{{ formatAmount($subscriber->unrealized_profit) }}
                                            </span>
                                        </td>
                                        <td>
                                            <span
                                                class="badge bg-{{ $subscriber->status === \App\Enum\UserCopyTradePlanStatus::ACTIVE ? 'success' : ($subscriber->status === \App\Enum\UserCopyTradePlanStatus::COMPLETED ? 'info' : 'danger') }}">
                                                {{ $subscriber->status->label() }}
                                            </span>
                                        </td>
                                        <td>{{ $subscriber->created_at->format('M d, Y') }}</td>
                                        <td class="text-end">
                                            @if ($subscriber->status === \App\Enum\UserCopyTradePlanStatus::ACTIVE)
                                                <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal"
                                                    data-bs-target="#addProfitModal{{ $subscriber->uuid }}">
                                                    <i class="ti ti-plus me-1"></i> Add Profit
                                                </button>

                                                <form
                                                    action="{{ route('admin.copy.trade.plan.terminate', $subscriber->uuid) }}"
                                                    method="POST" style="display: inline-block;">
                                                    @csrf
                                                    <button type="submit" class="btn btn-sm btn-danger"
                                                        onclick="return confirm('Are you sure you want to terminate this subscription? Use this action with caution.')">
                                                        <i class="ti ti-ban me-1"></i> Terminate
                                                    </button>
                                                </form>

                                                <!-- Add Profit Modal -->
                                                <div class="modal fade" id="addProfitModal{{ $subscriber->uuid }}"
                                                    tabindex="-1" aria-hidden="true">
                                                    <div class="modal-dialog text-start">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title">Add Profit/Loss for
                                                                    {{ $subscriber->user->name }}</h5>
                                                                <button type="button" class="btn-close"
                                                                    data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <form
                                                                action="{{ route('admin.copy.trade.plan.profit.add', $subscriber->uuid) }}"
                                                                method="POST">
                                                                @csrf
                                                                <div class="modal-body">
                                                                    <div class="mb-3">
                                                                        <label class="form-label">Amount
                                                                            ({{ currency($subscriber->user->currency) }})</label>
                                                                        <input type="number" step="any" name="amount"
                                                                            class="form-control"
                                                                            placeholder="e.g. 50 or -20" required>
                                                                        <small class="text-muted">Use negative value for
                                                                            loss.</small>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary"
                                                                        data-bs-dismiss="modal">Close</button>
                                                                    <button type="submit" class="btn btn-primary">Save
                                                                        Changes</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            @elseif ($subscriber->status === \App\Enum\UserCopyTradePlanStatus::CANCELLED)
                                                <form
                                                    action="{{ route('admin.copy.trade.plan.reactivate', $subscriber->uuid) }}"
                                                    method="POST" style="display: inline-block;">
                                                    @csrf
                                                    <button type="submit" class="btn btn-sm btn-warning"
                                                        onclick="return confirm('Reactivate this subscription?')">
                                                        <i class="ti ti-refresh me-1"></i> Reactivate
                                                    </button>
                                                </form>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="6" class="text-center py-4 text-muted">No subscribers found for this
                                            plan yet.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-3">
                        {{ $subscribers->links() }}
                    </div>
                </x-dashboard.card>
            </div>
        </div>

    </div>

    <!-- ? The amount {{ currency($subscriber->user->currency) }}{{ formatAmount($subscriber->amount) }} will be deducted from user wallet.') -->
@endsection
