@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.copy.trade.plan.index'),
                'text' => 'Back',
                'icon' => 'fa fa-arrow-left me-1',
            ]">

                <form action="{{ route('admin.copy.trade.plan.update', $copyTradePlan->uuid) }}" method="post">
                    @csrf
                    @method('PATCH')

                    <div class="row">
                        <x-dashboard.form-input name="name" label="Plan Name" class="col-md-6 mb-3"
                            value="{{ old('name', $copyTradePlan->name) }}" required />

                        <div class="col-md-6 mb-3">
                            <label class="form-label">Type</label>
                            <select name="type" class="form-select @error('type') is-invalid @enderror">
                                <option value="">Select</option>
                                @foreach ($planTypes as $planType)
                                    <option value="{{ $planType->value }}"
                                        {{ old('type', $copyTradePlan->type->value) == $planType->value ? 'selected' : '' }}>
                                        {{ $planType->label() }}
                                    </option>
                                @endforeach
                            </select>
                            @error('type')
                                <span class="invalid-feedback">{{ $message }}</span>
                            @enderror
                        </div>

                        <x-dashboard.form-input name="minimum" label="Minimum" class="col-md-6 mb-3" type="number"
                            value="{{ old('minimum', $copyTradePlan->minimum) }}" step="0.01" />

                        <x-dashboard.form-input name="maximum" label="Maximum" class="col-md-6 mb-3" type="number"
                            value="{{ old('maximum', $copyTradePlan->maximum) }}" step="0.01" />

                        <x-dashboard.form-input name="trades_per_day" label="Trades Per Day" class="col-md-6 mb-3"
                            type="number" value="{{ old('trades_per_day', $copyTradePlan->trades_per_day) }}"
                            placeholder="5" />

                        <x-dashboard.form-input name="daily_profit" label="Daily Profit (%)" class="col-md-6 mb-3"
                            type="number" value="{{ old('daily_profit', $copyTradePlan->daily_profit) }}" step="0.01"
                            min="0" max="100" />

                        <x-dashboard.form-input name="commission_percentage" label="Commission (%)" class="col-md-6 mb-3"
                            type="number"
                            value="{{ old('commission_percentage', $copyTradePlan->commission_percentage) }}"
                            step="0.01" min="0" max="100" />

                        <x-dashboard.form-input name="daily_profit_duration" label="Daily Profit Duration (Days)"
                            class="col-md-6 mb-3" type="number"
                            value="{{ old('daily_profit_duration', $copyTradePlan->daily_profit_duration) }}" />

                        <x-dashboard.form-input name="daily_profit_multiplication" label="Daily Profit Multiplication"
                            class="col-md-6 mb-3" type="number"
                            value="{{ old('daily_profit_multiplication', $copyTradePlan->daily_profit_multiplication) }}"
                            placeholder="2" />

                        <x-dashboard.form-input name="features[]" label="Features" class="col-md-12 mb-3" type="textarea"
                            value="{{ is_array(old('features')) ? implode(', ', old('features')) : old('features', implodeArray($copyTradePlan->features)) }}"
                            placeholder="Automated copy trading, Real-time signals, Risk management, Premium support" />
                    </div>

                    <x-dashboard.form-button />

                </form>

            </x-dashboard.card>
        </div>

    </div>
@endsection
