@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8">
                <div class="card shadow-sm mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Trade Details</h5>
                        <span class="{{ $trade->status->badge() }}">{{ $trade->status->label() }}</span>
                    </div>
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Name:</strong> {{ $trade->name }}</p>
                                <p class="mb-1"><strong>Trader:</strong> {{ $trade->trader->user->name }} ({{ $trade->trader->uuid }})</p>
                                <p class="mb-1"><strong>Description:</strong> {{ $trade->description ?? 'N/A' }}</p>
                            </div>
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Initial Amount:</strong> ${{ formatAmount($trade->initial_amount) }}</p>
                                <p class="mb-1 {{ $trade->profit_loss >= 0 ? 'text-success' : 'text-danger' }}">
                                    <strong>Total Profit/Loss:</strong> {{ $trade->profit_loss >= 0 ? '+' : '' }}${{ formatAmount($trade->profit_loss) }}
                                </p>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Started:</strong> {{ $trade->started_at ? $trade->started_at->format('M d, Y H:i') : 'N/A' }}</p>
                            </div>
                            <div class="col-md-6">
                                <p class="mb-1"><strong>Duration:</strong> {{ $trade->duration_hours ? $trade->duration_hours . ' hours' : 'No limit' }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Participants Table -->
                <div class="card shadow-sm">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Participants ({{ $trade->participants->count() }})</h5>
                        @if ($trade->isActive())
                            <a href="{{ route('admin.copy.trade.participants', $trade->uuid) }}" class="btn btn-primary btn-sm">
                                <i class="fa fa-user-plus me-1"></i> Add Participants
                            </a>
                        @endif
                    </div>
                    <div class="card-body">
                        @if ($trade->participants->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>User</th>
                                            <th>Wallet Address</th>
                                            <th>Invested</th>
                                            <th>Profit/Loss</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($trade->participants as $participant)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>
                                                    {{ $participant->user->name }}<br>
                                                    <small class="text-muted">{{ $participant->user->email }}</small>
                                                </td>
                                                <td><code style="font-size: 11px;">{{ Str::limit($participant->user->wallet_address, 20) }}</code></td>
                                                <td>${{ formatAmount($participant->invested_amount) }}</td>
                                                <td class="{{ $participant->profit_loss >= 0 ? 'text-success' : 'text-danger' }}">
                                                    {{ $participant->profit_loss >= 0 ? '+' : '' }}${{ formatAmount($participant->profit_loss) }}
                                                </td>
                                                <td>
                                                    @if ($participant->is_active)
                                                        <span class="badge bg-success">Active</span>
                                                    @else
                                                        <span class="badge bg-secondary">Inactive</span>
                                                    @endif
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-4 text-muted">
                                <i class="ti ti-users fs-1 mb-2 d-block"></i>
                                <p class="mb-0">No participants yet.</p>
                                @if ($trade->isActive())
                                    <a href="{{ route('admin.copy.trade.participants', $trade->uuid) }}" class="btn btn-primary mt-2">
                                        Add Participants
                                    </a>
                                @endif
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <!-- Actions -->
                @if ($trade->isActive())
                    <div class="card shadow-sm mb-3">
                        <div class="card-header">
                            <h5 class="mb-0">Trade Actions</h5>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="{{ route('admin.copy.trade.profit', $trade->uuid) }}" class="btn btn-success">
                                    <i class="fa fa-dollar me-1"></i> Add Profit/Loss
                                </a>
                                <a href="{{ route('admin.copy.trade.participants', $trade->uuid) }}" class="btn btn-primary">
                                    <i class="fa fa-user-plus me-1"></i> Manage Participants
                                </a>
                                <form action="{{ route('admin.copy.trade.complete', $trade->uuid) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="btn btn-warning w-100" 
                                        onclick="return confirm('Are you sure you want to complete this trade? This action cannot be undone.')">
                                        <i class="fa fa-check me-1"></i> Complete Trade
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                @endif

                <div class="card shadow-sm">
                    <div class="card-body">
                        <a href="{{ route('admin.copy.trade.index') }}" class="btn btn-outline-secondary w-100">
                            <i class="fa fa-arrow-left me-1"></i> Back to Trades
                        </a>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
