@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="card shadow-sm">
                    <div class="card-header">
                        <h5 class="mb-0">Add Profit or Loss to Participants</h5>
                    </div>
                    <div class="card-body">
                        @if ($trade->participants->count() > 0)
                            <form action="{{ route('admin.copy.trade.profit.add', $trade->uuid) }}" method="POST">
                                @csrf

                                <div class="alert alert-info mb-4">
                                    <strong>Info:</strong> Enter a positive number for profit or negative number for loss. 
                                    This amount will be added to each selected participant's profit/loss and their wallet balance.
                                </div>

                                <div class="mb-3">
                                    <label for="profit_loss" class="form-label">Profit/Loss Amount ($) <span class="text-danger">*</span></label>
                                    <input type="number" name="profit_loss" id="profit_loss" 
                                        class="form-control form-control-lg @error('profit_loss') is-invalid @enderror"
                                        value="{{ old('profit_loss') }}" 
                                        step="0.01"
                                        placeholder="e.g., 150.00 for profit or -50.00 for loss"
                                        required>
                                    @error('profit_loss')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-4">
                                    <label class="form-label">Apply To <span class="text-danger">*</span></label>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="apply_to" id="applyAll" value="all" checked>
                                        <label class="form-check-label" for="applyAll">
                                            All Participants ({{ $trade->participants->count() }} users)
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="apply_to" id="applySelected" value="selected">
                                        <label class="form-check-label" for="applySelected">
                                            Selected Participants Only
                                        </label>
                                    </div>
                                </div>

                                <div id="participantSelection" class="mb-4" style="display: none;">
                                    <label class="form-label">Select Participants</label>
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-sm">
                                            <thead>
                                                <tr>
                                                    <th style="width: 50px;">
                                                        <input type="checkbox" id="selectAll" class="form-check-input">
                                                    </th>
                                                    <th>User</th>
                                                    <th>Current P/L</th>
                                                    <th>Wallet Balance</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($trade->participants as $participant)
                                                    <tr>
                                                        <td>
                                                            <input type="checkbox" name="participant_ids[]" value="{{ $participant->id }}" class="form-check-input participant-checkbox">
                                                        </td>
                                                        <td>{{ $participant->user->name }}</td>
                                                        <td class="{{ $participant->profit_loss >= 0 ? 'text-success' : 'text-danger' }}">
                                                            {{ $participant->profit_loss >= 0 ? '+' : '' }}${{ formatAmount($participant->profit_loss) }}
                                                        </td>
                                                        <td>${{ formatAmount($participant->user->wallet_balance) }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>

                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-success" onclick="return confirm('Are you sure you want to add this profit/loss to participants?')">
                                        <i class="fa fa-dollar me-1"></i> Apply Profit/Loss
                                    </button>
                                    <a href="{{ route('admin.copy.trade.show', $trade->uuid) }}" class="btn btn-outline-secondary">
                                        Cancel
                                    </a>
                                </div>
                            </form>
                        @else
                            <div class="text-center py-5 text-muted">
                                <i class="ti ti-users-minus fs-1 mb-2 d-block"></i>
                                <h5>No Participants</h5>
                                <p class="mb-0">This trade has no participants yet. Add participants before adding profit/loss.</p>
                                <a href="{{ route('admin.copy.trade.participants', $trade->uuid) }}" class="btn btn-primary mt-3">
                                    <i class="fa fa-user-plus me-1"></i> Add Participants
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

    </div>

    <script>
        document.querySelectorAll('input[name="apply_to"]').forEach(radio => {
            radio.addEventListener('change', function() {
                document.getElementById('participantSelection').style.display = 
                    this.value === 'selected' ? 'block' : 'none';
            });
        });

        document.getElementById('selectAll')?.addEventListener('change', function() {
            const checkboxes = document.querySelectorAll('.participant-checkbox');
            checkboxes.forEach(cb => cb.checked = this.checked);
        });
    </script>
@endsection
