@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="card shadow-sm">
                    <div class="card-header">
                        <h5 class="mb-0">Select Users to Add as Participants</h5>
                    </div>
                    <div class="card-body">
                        @if ($eligibleUsers->count() > 0)
                            <form action="{{ route('admin.copy.trade.participants.add', $trade->uuid) }}" method="POST">
                                @csrf

                                <div class="alert alert-info mb-4">
                                    <strong>Note:</strong> Only users with approved copy trade requests for this trader and connected wallets are shown.
                                </div>

                                <div class="mb-4 p-3 bg-light rounded border">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" id="deductBalance" name="deduct_balance" value="1" checked>
                                        <label class="form-check-label fw-bold" for="deductBalance">
                                            Deduct investment amount from user's live balance?
                                        </label>
                                    </div>
                                    <small class="text-muted d-block mt-1">
                                        If enabled, the trade's initial amount (${{ formatAmount($trade->initial_amount) }}) will be deducted from each selected participant's wallet.
                                    </small>
                                </div>

                                <div class="table-responsive mb-4">
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th style="width: 50px;">
                                                    <input type="checkbox" id="selectAll" class="form-check-input">
                                                </th>
                                                <th>User</th>
                                                <th>Email</th>
                                                <th>Wallet Address</th>
                                                <th>Wallet Balance</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($eligibleUsers as $user)
                                                <tr>
                                                    <td>
                                                        <input type="checkbox" name="user_ids[]" value="{{ $user->id }}" class="form-check-input user-checkbox">
                                                    </td>
                                                    <td>{{ $user->name }}</td>
                                                    <td>{{ $user->email }}</td>
                                                    <td><code style="font-size: 11px;">{{ Str::limit($user->wallet_address, 25) }}</code></td>
                                                    <td>${{ formatAmount($user->wallet_balance) }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <div class="d-flex gap-2">
                                    <button type="submit" class="btn btn-primary" onclick="return confirm('Add selected users to this trade?')">
                                        <i class="fa fa-user-plus me-1"></i> Add Selected Participants
                                    </button>
                                    <a href="{{ route('admin.copy.trade.show', $trade->uuid) }}" class="btn btn-outline-secondary">
                                        Cancel
                                    </a>
                                </div>
                            </form>
                        @else
                            <div class="text-center py-5 text-muted">
                                <i class="ti ti-users-minus fs-1 mb-2 d-block"></i>
                                <h5>No Eligible Users Found</h5>
                                <p class="mb-0">There are no users with approved copy trade requests and connected wallets who are not already participants in this trade.</p>
                                <a href="{{ route('admin.copy.trade.show', $trade->uuid) }}" class="btn btn-outline-secondary mt-3">
                                    <i class="fa fa-arrow-left me-1"></i> Back to Trade
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

    </div>

    <script>
        document.getElementById('selectAll')?.addEventListener('change', function() {
            const checkboxes = document.querySelectorAll('.user-checkbox');
            checkboxes.forEach(cb => cb.checked = this.checked);
        });
    </script>
@endsection
