@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <x-dashboard.card title="{{ $title }}" :button="[
                'route' => route('admin.copy.trade.create'),
                'text' => 'Create New Trade',
                'icon' => 'fa fa-plus me-1',
            ]">

                <!-- Filter -->
                <div class="mb-3">
                    <form action="{{ route('admin.copy.trade.index') }}" method="GET" class="row g-2">
                        <div class="col-md-3">
                            <select name="status" class="form-select">
                                <option value="">All Status</option>
                                <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed
                                </option>
                                <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled
                                </option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button type="submit" class="btn btn-primary">Filter</button>
                        </div>
                    </form>
                </div>

                <div class="table-responsive d-none d-md-block">
                    <table id="myTable" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Initial Amount</th>
                                <th>Profit/Loss</th>
                                <th>Participants</th>
                                <th>Status</th>
                                <th>Started</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($trades as $trade)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $trade->name }}</td>
                                    <td>${{ formatAmount($trade->initial_amount) }}</td>
                                    <td class="{{ $trade->profit_loss >= 0 ? 'text-success' : 'text-danger' }}">
                                        {{ $trade->profit_loss >= 0 ? '+' : '' }}${{ formatAmount($trade->profit_loss) }}
                                    </td>
                                    <td>{{ $trade->participants_count }}</td>
                                    <td>
                                        <span class="{{ $trade->status->badge() }}">{{ $trade->status->label() }}</span>
                                    </td>
                                    <td>{{ $trade->started_at ? $trade->started_at->format('M d, Y') : 'N/A' }}</td>
                                    <td>
                                        <a href="{{ route('admin.copy.trade.show', $trade->uuid) }}"
                                            class="btn btn-info btn-sm m-1">
                                            <i class="fa fa-file-text me-1"></i> View
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="d-block d-md-none">
                    @forelse ($trades as $trade)
                        <div class="card mb-3 shadow-sm">
                            <div class="card-body">
                                <h5 class="card-title">{{ $trade->name }}</h5>
                                <p class="mb-1"><strong>Initial:</strong> ${{ formatAmount($trade->initial_amount) }}</p>
                                <p class="mb-1 {{ $trade->profit_loss >= 0 ? 'text-success' : 'text-danger' }}">
                                    <strong>P/L:</strong>
                                    {{ $trade->profit_loss >= 0 ? '+' : '' }}${{ formatAmount($trade->profit_loss) }}
                                </p>
                                <p class="mb-1"><strong>Participants:</strong> {{ $trade->participants_count }}</p>
                                <p class="mb-2">
                                    <strong>Status:</strong>
                                    <span class="{{ $trade->status->badge() }}">{{ $trade->status->label() }}</span>
                                </p>
                                <a href="{{ route('admin.copy.trade.show', $trade->uuid) }}" class="btn btn-info btn-sm">
                                    <i class="fa fa-file-text me-1"></i> View
                                </a>
                            </div>
                        </div>
                    @empty
                        <div class="text-center py-4 text-muted">
                            No copy trades found.
                        </div>
                    @endforelse
                </div>

                {{ $trades->links() }}

            </x-dashboard.card>
        </div>

    </div>
@endsection
