@extends('dashboard.admin.layouts.app')
@section('content')
    <div class="page-container">

        <div class="page-title-head d-flex align-items-sm-center flex-sm-row flex-column gap-2">
            <div class="flex-grow-1">
                <h4 class="fs-18 fw-semibold mb-0">{{ $title }}</h4>
            </div>

            <div class="text-end">
                <x-dashboard.breadcrumbs :breadcrumbs="$breadcrumbs" />
            </div>
        </div>

        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="card shadow-sm">
                    <div class="card-header">
                        <h5 class="mb-0">Create New Copy Trade</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.copy.trade.store') }}" method="POST">
                            @csrf

                            <div class="mb-3">
                                <label for="trader_id" class="form-label">Select Trader <span class="text-danger">*</span></label>
                                <select name="trader_id" id="trader_id" class="form-select @error('trader_id') is-invalid @enderror" required>
                                    <option value="">Select a trader</option>
                                    @foreach ($traders as $trader)
                                        <option value="{{ $trader->id }}" {{ old('trader_id') == $trader->id ? 'selected' : '' }}>
                                            {{ $trader->user->name }} ({{ $trader->uuid }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('trader_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="name" class="form-label">Trade Name <span class="text-danger">*</span></label>
                                <input type="text" name="name" id="name" 
                                    class="form-control @error('name') is-invalid @enderror"
                                    value="{{ old('name') }}" 
                                    placeholder="e.g., BTC/USD Long Position"
                                    required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea name="description" id="description" 
                                    class="form-control @error('description') is-invalid @enderror"
                                    rows="3" 
                                    placeholder="Describe the trade strategy...">{{ old('description') }}</textarea>
                                @error('description')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="initial_amount" class="form-label">Initial Amount ($) <span class="text-danger">*</span></label>
                                    <input type="number" name="initial_amount" id="initial_amount" 
                                        class="form-control @error('initial_amount') is-invalid @enderror"
                                        value="{{ old('initial_amount', 0) }}" 
                                        step="0.01" min="0"
                                        required>
                                    @error('initial_amount')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label for="duration_hours" class="form-label">Duration (Hours)</label>
                                    <input type="number" name="duration_hours" id="duration_hours" 
                                        class="form-control @error('duration_hours') is-invalid @enderror"
                                        value="{{ old('duration_hours') }}" 
                                        min="1"
                                        placeholder="Optional">
                                    @error('duration_hours')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="text-muted">Leave empty for no time limit</small>
                                </div>
                            </div>

                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-save me-1"></i> Create Trade
                                </button>
                                <a href="{{ route('admin.copy.trade.index') }}" class="btn btn-outline-secondary">
                                    Cancel
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
