<div class="table-responsive">
    <table id="myTable" class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>Reference ID</th>
                <th>Type</th>
                <th>Description</th>
                <th>Amount</th>
                <th>Date</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($transactions as $transaction)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $transaction->reference_id }}</td>
                    <td>
                        {{ $transaction->type->label() }}
                    </td>
                    <td>
                        {{ $transaction->description ?? 'N/A' }}
                    </td>
                    <td>
                        @if ($transaction->isDirectionCredit())
                            <span
                                class="text-success">+{{ currency($user->currency) }}{{ formatAmount($transaction->amount) }}</span>
                        @else
                            <span
                                class="text-danger">-{{ currency($user->currency) }}{{ formatAmount($transaction->amount) }}</span>
                        @endif
                    </td>
                    <td>
                        {{ formatDateTime($transaction->transaction_at) }}
                    </td>
                    <td>
                        <span class="{{ $transaction->status->badge() }}">
                            {{ $transaction->status->label() }}
                        </span>
                    </td>
                    @if (request()->routeIs('admin.user.transaction.*'))
                        <td>
                            <a href="{{ route('admin.user.transaction.show', [$user->uuid, $transaction->uuid]) }}"
                                class="btn btn-info btn-sm m-1">
                                <i class="fa fa-file-text me-1"></i> View
                            </a>

                            <form
                                action="{{ route('admin.user.transaction.delete', [$user->uuid, $transaction->uuid]) }}"
                                method="post">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm m-1"
                                    onclick="return confirm('Are you sure you want to delete this transaction?')">
                                    <i class="ti ti-trash me-1"></i>Delete
                                </button>
                            </form>
                        </td>
                    @else
                        <td>
                            <a href="{{ route('user.transaction.show', $transaction->uuid) }}"
                                class="btn btn-info btn-sm m-1">
                                <i class="fa fa-file-text me-1"></i> View
                            </a>
                        </td>
                    @endif
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
