<div class="card {{ $class ?? '' }}">
    @if (!empty($title))
        <div class="card-header border-bottom d-flex flex-wrap justify-content-between align-items-center gap-2">
            @if (empty($leftSide))
                @if (empty($subtitle))
                    <h4 class="header-title m-0">
                        <i class="{{ $icon ?? '' }}"></i>{{ $title }}
                    </h4>
                @else
                    <div class="m-0">
                        <span class="h4 header-title d-block">
                            <i class="{{ $icon ?? '' }}"></i>{{ $title }}
                        </span>
                        <small class="text-muted d-block">{{ $subtitle ?? '' }}</small>
                    </div>
                @endif
            @else
                <div class="m-0">
                    {{ $leftSide }}
                </div>
            @endif

            @if (!empty($button))
                <a href="{{ $button['route'] }}" class="btn btn-primary btn-sm mt-2 mt-sm-0">
                    <i class="{{ $button['icon'] ?? 'fa fa-plus me-1' }}"></i>
                    {{ $button['text'] ?? 'Create' }}
                </a>
            @elseif(!empty($link))
                <a href="{{ $link['route'] }}"
                    class="text-decoration-none small text-muted mt-2 mt-sm-0">{{ $link['text'] }}
                </a>
            @endif

            @if (!empty($rightSide))
                <div class="m-0 mt-2 mt-sm-0">
                    {{ $rightSide }}
                </div>
            @endif
        </div>
    @endif

    <div class="card-body p-4">
        {{ $slot }}
    </div>

    @if (!empty($footer))
        <div class="card-footer border-top">
            {{ $footer }}
        </div>
    @endif
</div>
