@props([
    'user' => null,
])

<div class="card shadow-sm border-0 mb-4">
    <div class="card-header border-bottom">
        <div class="d-flex align-items-center justify-content-between">
            <h5 class="mb-0 fw-semibold">
                <i class="bi bi-wallet2 text-primary me-1"></i>
                Account Balances
            </h5>
        </div>
    </div>

    <div class="card-body">

        <!-- Balance Grid -->
        <div class="row g-4">

            <!-- Live Balance -->
            <div class="col-md-6 col-lg-4">
                <div class="border rounded-3 p-3 h-100">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <span class="text-muted fw-medium">Live Balance</span>
                        <i class="bi bi-cash-stack text-success"></i>
                    </div>

                    <h4 class="fw-bold mb-0">
                        {{ currency($user->currency) }}{{ formatAmount($user->balance) }}
                    </h4>

                    <small class="text-muted">
                        {{ currency($user->currency, 'code') }} Wallet
                    </small>
                </div>
            </div>

            <!-- Demo Balance -->
            <div class="col-md-6 col-lg-4">
                <div class="border rounded-3 p-3 h-100">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <span class="text-muted fw-medium">Demo Balance</span>
                        <i class="bi bi-controller text-primary"></i>
                    </div>

                    <h4 class="fw-bold mb-0">
                        {{ currency($user->currency) }}{{ formatAmount($user->demo_balance) }}
                    </h4>

                    <small class="text-muted">
                        Practice Funds
                    </small>
                </div>
            </div>

            <!-- Slot for Future Columns -->
            {{ $slot }}

        </div>
    </div>
</div>
