<div class="table-responsive d-none d-md-block">
    <table id="myTable" class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Status</th>
                <th>Created At</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($users as $user)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td><a href="{{ route('admin.user.show', $user->uuid) }}">{{ $user->name }}</a>
                    </td>
                    <td>{{ $user->email }}</td>
                    <td>{{ $user->phone }}</td>
                    <td>
                        <span class="{{ $user->status->badge() }}"> {{ $user->status->label() }} </span>
                    </td>
                    <td>
                        {{ $user->created_at->diffForHumans() }}
                    </td>
                    <td>
                        <a href="{{ route('admin.user.login', $user->uuid) }}" class="btn btn-success btn-sm m-1">
                            <i class="fa fa-sign-in me-1"></i> Login
                        </a>

                        <a href="{{ route('admin.user.show', $user->uuid) }}" class="btn btn-info btn-sm m-1">
                            <i class="fa fa-file-text me-1"></i> View
                        </a>

                        <a href="{{ route('admin.user.edit', $user->uuid) }}" class="btn btn-primary btn-sm m-1">
                            <i class="fa fa-edit me-1"></i> Edit
                        </a>

                        <form action="{{ route('admin.user.delete', $user->uuid) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-sm m-1"
                                onclick="return confirm('Are you sure you want to delete this user?')">
                                <i class="fa fa-trash me-1"></i>Delete
                            </button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<div class="d-block d-md-none">
    @foreach ($users as $user)
        <div class="card mb-3 shadow-sm">
            <div class="card-body">
                <h5 class="card-title">
                    <strong> Name:</strong>
                    {{ $user->name }}
                </h5>

                <p class="mb-1"><strong>Email:</strong>
                    {{ $user->email }}
                </p>
                <p class="mb-1"><strong>Phone:</strong>
                    {{ $user->phone }}
                </p>
                <p class="mb-1"><strong>Status:</strong>
                    <span class="{{ $user->status->badge() }}"> {{ $user->status->label() }} </span>
                </p>
                <p class="mb-2"><strong>Created:</strong>
                    {{ $user->created_at->diffForHumans() }}
                </p>

                <div class="d-flex gap-2">
                    <a href="{{ route('admin.user.show', $user->uuid) }}" class="btn btn-info btn-sm m-1">
                        <i class="fa fa-file-text me-1"></i> View
                    </a>

                    <a href="{{ route('admin.user.edit', $user->uuid) }}" class="btn btn-primary btn-sm m-1">
                        <i class="fa fa-edit me-1"></i> Edit
                    </a>

                    <form action="{{ route('admin.user.delete', $user->uuid) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm m-1"
                            onclick="return confirm('Are you sure you want to delete this user?')">
                            <i class="fa fa-trash me-1"></i>Delete
                        </button>
                    </form>
                </div>
            </div>
        </div>
    @endforeach
</div>
