<?php

namespace Database\Seeders;

use App\Models\TradeBot;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class TradeBotSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        TradeBot::create([
            'uuid' => Str::uuid(),
            'name' => 'Conservative Bot',

            'minimum' => 100,
            'maximum' => 5000,
            'currency' => 'United State Dollar-USD-$',

            // market IDs ONLY
            'asset_pairs' => [1],

            'features' => [
                'stop_loss',
                'take_profit',
            ],

            'parameters' => [
                'strategy: RSI',
                'risk_percent: 2',
                'timeframe 15m',
            ],

            'description' => 'Low-risk trading bot',
        ]);
    }
}
