<?php

namespace Database\Seeders;

use App\Models\Plan;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class PlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'name' => 'Starter Plan',
                'type' => 'basic',

                'minimum' => 100.00,
                'maximum' => 1000.00,

                'daily_profit' => 2.00, // 2%
                'daily_profit_duration' => 30,
                'trades_per_day' => 3,

                'features' => [
                    '24/7 Support',
                    'Access to basic signals',
                    'Low risk trades',
                ],
            ],
            [
                'name' => 'Pro Plan',
                'type' => 'advanced',

                'minimum' => 1000.00,
                'maximum' => 10000.00,

                'daily_profit' => 5.00, // 5%
                'daily_profit_duration' => 30,
                'trades_per_day' => 5,

                'features' => [
                    'Priority Support',
                    'Access to all signals',
                    'Medium risk trades',
                    'Weekly reports',
                ],
            ],
            [
                'name' => 'Elite Plan',
                'type' => 'premium',

                'minimum' => 10000.00,
                'maximum' => 100000.00,

                'daily_profit' => 10.00, // 10%
                'daily_profit_duration' => 30,
                'trades_per_day' => 10,

                'features' => [
                    'Dedicated account manager',
                    'Exclusive trading signals',
                    'High risk / high reward',
                    'Daily performance reports',
                ],
            ],
        ];

        foreach ($plans as $plan) {
            Plan::create([
                'uuid' => Str::uuid(),
                ...$plan,
            ]);
        }
    }
}
