<?php

namespace Database\Seeders;

use Carbon\Carbon;
use App\Models\Market;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class MarketSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $markets = [
            ['asset' => 'VET / USDT'],
            ['asset' => 'XRP / USDT'],
            ['asset' => 'ICP / USDT'],
            ['asset' => 'LINK / USDT'],
            ['asset' => 'BNB / USDT'],
            ['asset' => 'TRX / USDT'],
            ['asset' => 'BCH / USDT'],
            ['asset' => 'AVAX / USDT'],
            ['asset' => 'XMR / USDT'],
            ['asset' => 'ADA / USDT'],
            ['asset' => 'DOGE / USDT'],
            ['asset' => 'MATIC / USDT'],
            ['asset' => 'SOL / USDT'],
            ['asset' => 'DOT / USDT'],
            ['asset' => 'ETH / USDT'],
            ['asset' => 'BTC / USDT'],
        ];

        foreach ($markets as $market) {
            // Normalize asset (remove spaces)
            $asset = str_replace(' ', '', $market['asset']);

            // Generate symbol (remove slash)
            $symbol = str_replace('/', '', $asset);

            Market::create([
                'uuid'   => (string) Str::uuid(),
                'asset'  => $market['asset'], // e.g. "BTC / USDT"
                'symbol' => strtoupper($symbol), // e.g. "BTCUSDT"
                'rate'   => 0,
                'price'  => 0,
                'high'   => 0,
                'low'    => 0,
                'volume' => 0,
            ]);
        }
    }
}
