<?php

namespace Database\Seeders;

use App\Enum\UserRole;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        User::factory()->create([
            'name' => 'Test User',
            'email' => 'user@gmail.com',
        ]);

        User::factory()->create([
            'role' => UserRole::ADMIN->value,
            'name' => 'Test Admin',
            'email' => 'admin@gmail.com',
        ]);

        User::factory()->create([
            'role' => UserRole::MASTER->value,
            'name' => 'Test Master',
            'email' => 'master@gmail.com',
        ]);

        $this->call([
            MarketSeeder::class,
            PlanSeeder::class,
            WalletSeeder::class,
            SignalSeeder::class,
            TradeBotSeeder::class,
            SettingSeeder::class
        ]);
    }
}
