<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_copy_trade_plans', function (Blueprint $table) {
            $table->id();
            $table->uuid()->unique();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->foreignId('copy_trade_plan_id')->constrained('copy_trade_plans')->cascadeOnDelete();
            $table->decimal('amount', 16, 2)->comment('Amount deducted from wallet balance');
            $table->decimal('daily_profit', 5, 2)->comment('Daily profit percentage at subscription time');
            $table->decimal('commission_percentage', 5, 2);
            $table->decimal('unrealized_profit', 15, 2)->default(0.00);
            $table->integer('duration');
            $table->unsignedSmallInteger('trades_per_day')->default(1);
            $table->unsignedInteger('days_processed')->default(0);
            $table->timestamp('starts_at')->nullable();
            $table->timestamp('ends_at')->nullable();

            $table->enum('status', ['active', 'completed', 'cancelled'])->default('active');
            $table->timestamps();

            $table->index('user_id');
            $table->index('copy_trade_plan_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_copy_trade_plans');
    }
};
