<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('trade_bots', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();
            $table->string('name');

            // Minimum and maximum capital a user can allocate
            $table->decimal('minimum', 16, 2);
            $table->decimal('maximum', 16, 2);

            $table->string('currency'); // Base currency (USD, USDT, etc)

            // List of tradable market IDs (normalized, not symbols)
            $table->json('asset_pairs');

            // Bot features
            $table->json('features');

            // Strategy parameters (RSI levels, risk %, timeframe, etc)
            $table->json('parameters');

            // Marketing / explanation
            $table->text('description')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('trade_bots');
    }
};
