<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('swaps', function (Blueprint $table) {
            $table->id();
            $table->uuid()->unique();

            // User relationship
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();

            // From market (source crypto)
            $table->foreignId('from_market_id')->constrained('markets')->cascadeOnDelete();

            // To market (target crypto)
            $table->foreignId('to_market_id')->constrained('markets')->cascadeOnDelete();

            // Amount to swap (in source crypto)
            $table->decimal('from_amount', 18, 8);

            // Amount received (in target crypto)
            $table->decimal('to_amount', 18, 8)->nullable();

            // Price information
            $table->decimal('rate', 18, 8); // Exchange rate used
            $table->decimal('fee', 18, 8)->default(0); // Fee deducted

            // Status: pending, completed, failed
            $table->enum('status', ['pending', 'completed', 'failed'])->default('completed');

            // Timestamps
            $table->timestamp('swapped_at')->nullable();
            $table->timestamps();

            // Indexes for performance
            $table->index('user_id');
            $table->index('status');
            $table->index('created_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('swaps');
    }
};
