<?php

use App\Models\Plan;
use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_plans', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique();

            $table->foreignIdFor(User::class)->constrained()->cascadeOnDelete();
            $table->foreignIdFor(Plan::class)->constrained()->cascadeOnDelete();

            $table->decimal('amount', 16, 2);                // capital invested
            $table->decimal('daily_profit', 5, 2);          // percentage (e.g 2.5)
            $table->unsignedInteger('duration');            // total days
            $table->unsignedSmallInteger('trades_per_day');

            $table->unsignedInteger('days_processed')->default(0);

            $table->dateTime('starts_at');
            $table->dateTime('ends_at');

            $table->enum('status', ['active', 'completed', 'cancelled'])->default('active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_plans');
    }
};
