<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('markets', function (Blueprint $table) {
            $table->id();

            // UUID
            $table->uuid()->unique();

            // Market pair (BTC / USDT)
            $table->string('asset', 50)->unique();

            // Symbol (BTCUSDT)
            $table->string('symbol', 50)->unique();

            // Price metrics (high precision decimals)
            $table->decimal('rate', 18, 8)->default(0);
            $table->decimal('price', 18, 8)->default(0);
            $table->decimal('high', 18, 8)->default(0);
            $table->decimal('low', 18, 8)->default(0);

            // Volume
            $table->decimal('volume', 24, 8)->default(0);

            $table->timestamps();

            // Indexes for performance
            $table->index('asset');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('markets');
    }
};
