<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('plans', function (Blueprint $table) {
            $table->id();
            $table->uuid()->unique();
            $table->string('name');
            $table->enum('type', ['basic', 'advanced', 'premium'])->default('basic');
            $table->decimal('minimum', 16, 2);
            $table->decimal('maximum', 16, 2);
            $table->decimal('daily_profit', 5, 2);
            $table->unsignedInteger('daily_profit_duration');
            $table->unsignedInteger('daily_profit_multiplication')->default(0);
            $table->unsignedSmallInteger('trades_per_day');
            $table->json('features')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('plans');
    }
};
