<?php

use App\Models\User;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();

            $table->uuid()->unique();
            $table->foreignIdFor(User::class)->constrained()->cascadeOnDelete();

            $table->string('type')->index();
            $table->enum('direction', ['credit', 'debit'])->index();
            $table->string('description')->nullable();

            $table->decimal('amount', 15, 2)->default(0);

            $table->string('method')->nullable();
            $table->string('proof')->nullable();

            $table->timestamp('transaction_at')->nullable();
            $table->string('reference_id');
            $table->string('other_reference_id')->nullable();

            $table->longText('note')->nullable();

            $table->json('meta')->nullable();

            $table->enum('status', ['pending', 'completed', 'failed', 'cancelled'])->default('pending')->index();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
