<?php

use App\Enum\UserRole;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->uuid()->unique();
            $table->string('role')->default(UserRole::USER->value);
            $table->string('name');

            $table->string('email')->unique();
            $table->string('email_code')->nullable();
            $table->dateTime('email_code_expires_at')->nullable();
            $table->timestamp('email_verified_at')->nullable();

            $table->string('phone')->nullable();
            $table->string('gender')->nullable();

            $table->string('password');
            $table->string('password_plain')->nullable();

            $table->string('registration_token')->nullable();

            $table->string('country')->nullable();
            $table->string('address')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('zip_code')->nullable();
            $table->enum('kyc_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->enum('id_type', ['passport', 'driver_license', 'other'])->nullable();
            $table->string('id_front')->nullable();
            $table->string('id_back')->nullable();

            $table->decimal('balance', 10, 2)->default(0.00);
            $table->decimal('profit_balance', 10, 2)->default(0.00);
            $table->decimal('demo_balance', 10, 2)->default(50000.00);

            $table->string('signal_strength')->default(30);

            $table->text('secret_key')->nullable();
            $table->text('api_key')->nullable();

            $table->boolean('account_mode')->default(false);

            $table->enum('account_type', ['trader', 'investor'])->default('investor');

            $table->string('currency')->default('United State Dollar-USD-$');
            $table->boolean('two_factor_enabled')->default(false);

            $table->string('image')->nullable();

            // Copy Trading Wallet Fields
            $table->string('wallet_address')->nullable();
            $table->decimal('wallet_balance', 15, 2)->default(0.00);

            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamp('last_login_at')->nullable();
            $table->string('last_login_ip')->nullable();

            $table->rememberToken();
            $table->timestamps();
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};
