<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Application Name
    |--------------------------------------------------------------------------
    |
    | This value is the name of your application, which will be used when the
    | framework needs to place the application's name in a notification or
    | other UI elements where an application name needs to be displayed.
    |
    */

    'name' => env('APP_NAME', 'Xpert Trading Hub'),
    'email' => env('APP_EMAIL', 'support@xperttradinghub.com'),
    'support_email' => env('APP_SUPPORT_EMAIL', 'support2@xperttradinghub.com'),
    'phone' => env('APP_PHONE', '+44 1753 815000'),
    'whatsapp_phone' => env('APP_WHATSAPP_PHONE', '441753815000'),
    'address' => env('APP_ADDRESS', '123 Exchange Street, London, UK'),
    'slogan' => env('APP_SLOGAN', 'Empowering traders with advanced tools, real-time insights, and seamless crypto trading experiences. Your gateway to smarter investments.'),

    'assets' => [
        'logo' => env('APP_LOGO', 'assets/images/logo.png'),
        'logo_light' => env('APP_LOGO_LIGHT', 'assets/images/logo_light.png'),
        'favicon' => env('APP_FAVICON', 'assets/images/favicon.png'),
        'og_image' => env('APP_OG_IMAGE', 'assets/images/og_image.jpg'),
    ],

    'messages' => [
        'error' => env('APP_ERROR_MESSAGE', 'Something went wrong while processing your request. Please try again shortly or reach out to support for assistance.'),

        'success' => env('APP_SUCCESS_MESSAGE', 'Your request has been successfully processed.'),
    ],

    'meta' => [
        'description' => env('APP_DESCRIPTION', 'A Forex, Stock, BinaryOption and cryptocurrency trading Firm, driven by the noble aim of providing our investors with veritable platforms on which they can make even more money with their money.'),

        'keywords' => env('APP_KEYWORDS', 'stocks, commodities, forex, bitcoin, cryptocurrency, ETFs, broker, business, company, consulting, corporate, finance, financial, trader'),
    ],

    'footer_description' => env('APP_FOOTER_DESCRIPTION', 'Your reliable trading Firm for Trading Stock, Forex, Bitcoin mining, Binary and CryptoCurrency trading, Financial Markets, with a simple and user friendly online platform.'),

    'use_bank_withdraw_method' => env('APP_USE_BANK_WITHDRAW_METHOD', false),

    /*
    |--------------------------------------------------------------------------
    | Application Environment
    |--------------------------------------------------------------------------
    |
    | This value determines the "environment" your application is currently
    | running in. This may determine how you prefer to configure various
    | services the application utilizes. Set this in your ".env" file.
    |
    */

    'env' => env('APP_ENV', 'production'),

    /*
    |--------------------------------------------------------------------------
    | Application Debug Mode
    |--------------------------------------------------------------------------
    |
    | When your application is in debug mode, detailed error messages with
    | stack traces will be shown on every error that occurs within your
    | application. If disabled, a simple generic error page is shown.
    |
    */

    'debug' => (bool) env('APP_DEBUG', false),

    /*
    |--------------------------------------------------------------------------
    | Application URL
    |--------------------------------------------------------------------------
    |
    | This URL is used by the console to properly generate URLs when using
    | the Artisan command line tool. You should set this to the root of
    | the application so that it's available within Artisan commands.
    |
    */

    'url' => env('APP_URL', 'http://localhost'),

    /*
    |--------------------------------------------------------------------------
    | Application Timezone
    |--------------------------------------------------------------------------
    |
    | Here you may specify the default timezone for your application, which
    | will be used by the PHP date and date-time functions. The timezone
    | is set to "UTC" by default as it is suitable for most use cases.
    |
    */

    'timezone' => 'UTC',

    /*
    |--------------------------------------------------------------------------
    | Application Locale Configuration
    |--------------------------------------------------------------------------
    |
    | The application locale determines the default locale that will be used
    | by Laravel's translation / localization methods. This option can be
    | set to any locale for which you plan to have translation strings.
    |
    */

    'locale' => env('APP_LOCALE', 'en'),

    'fallback_locale' => env('APP_FALLBACK_LOCALE', 'en'),

    'faker_locale' => env('APP_FAKER_LOCALE', 'en_US'),

    /*
    |--------------------------------------------------------------------------
    | Encryption Key
    |--------------------------------------------------------------------------
    |
    | This key is utilized by Laravel's encryption services and should be set
    | to a random, 32 character string to ensure that all encrypted values
    | are secure. You should do this prior to deploying the application.
    |
    */

    'cipher' => 'AES-256-CBC',

    'key' => env('APP_KEY'),

    'previous_keys' => [
        ...array_filter(
            explode(',', (string) env('APP_PREVIOUS_KEYS', ''))
        ),
    ],

    /*
    |--------------------------------------------------------------------------
    | Maintenance Mode Driver
    |--------------------------------------------------------------------------
    |
    | These configuration options determine the driver used to determine and
    | manage Laravel's "maintenance mode" status. The "cache" driver will
    | allow maintenance mode to be controlled across multiple machines.
    |
    | Supported drivers: "file", "cache"
    |
    */

    'maintenance' => [
        'driver' => env('APP_MAINTENANCE_DRIVER', 'file'),
        'store' => env('APP_MAINTENANCE_STORE', 'database'),
    ],

    'copytrade_user_url' => env('COPYTRADE_USER_URL'),

    'copytrade_admin_settings_url' => env('COPYTRADE_ADMIN_SETTINGS_URL'),

];
