<?php

namespace App\Models;

use Illuminate\Support\Str;
use App\Enum\UserPlanStatus;
use Illuminate\Database\Eloquent\Model;

class UserPlan extends Model
{
    protected $guarded = [];

    protected $casts = [
        'status' => UserPlanStatus::class
    ];

    protected static function booted()
    {
        static::creating(function ($trade) {
            $trade->uuid = Str::uuid();
        });
    }

    public function getRouteKeyName()
    {
        return 'uuid';
    }

    public function plan()
    {
        return $this->belongsTo(Plan::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
