<?php

namespace App\Models;

use Illuminate\Support\Str;
use App\Enum\UserCopyTradePlanStatus;
use Illuminate\Database\Eloquent\Model;

class UserCopyTradePlan extends Model
{
    protected $guarded = [];

    protected $casts = [
        'status' => UserCopyTradePlanStatus::class,
        'amount' => 'decimal:2',
        'daily_profit' => 'decimal:2',
        'commission_percentage' => 'decimal:2',
        'starts_at' => 'datetime',
        'ends_at' => 'datetime',
        'duration' => 'integer',
        'trades_per_day' => 'integer',
        'days_processed' => 'integer'
    ];

    protected static function booted()
    {
        static::creating(function ($trade) {
            $trade->uuid = Str::uuid();
        });
    }

    public function getRouteKeyName()
    {
        return 'uuid';
    }

    public function copyTradePlan()
    {
        return $this->belongsTo(CopyTradePlan::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
