<?php

namespace App\Models;

use Illuminate\Support\Str;
use App\Enum\TransactionType;
use App\Enum\TransactionMethod;
use App\Enum\TransactionStatus;
use App\Enum\TransactionDirection;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    protected $guarded = [];

    protected $casts = [
        'meta' => 'array',
        'type' => TransactionType::class,
        'direction' => TransactionDirection::class,
        'status' => TransactionStatus::class,
        'method' => TransactionMethod::class
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (empty($model->uuid)) {
                $model->uuid = (string) Str::uuid();
            }
        });
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function isDirectionCredit()
    {
        return $this->direction->value == TransactionDirection::CREDIT->value;
    }

    public function isDirectionDebit()
    {
        return $this->direction->value == TransactionDirection::DEBIT->value;
    }

    public function methodIsBank()
    {
        return $this->method->value == TransactionMethod::BANK->value;
    }


    public function methodIsCrypto()
    {
        return $this->method->value == TransactionMethod::CRYPTO->value;
    }
}
