<?php

namespace App\Models;

use Illuminate\Support\Str;
use App\Enum\TradeBotUserStatus;
use Illuminate\Database\Eloquent\Model;

class TradeBotUser extends Model
{
    protected $guarded = [];

    protected $casts = [
        'status' => TradeBotUserStatus::class,
        'meta' => 'array',
        'started_at' => 'datetime',
    ];
    protected static function booted()
    {
        static::creating(function ($trade) {
            $trade->uuid = Str::uuid();
        });
    }

    // Strategy used by this bot
    public function tradeBot()
    {
        return $this->belongsTo(TradeBot::class);
    }

    // Trades executed by this bot
    public function trades()
    {
        return $this->hasMany(Trade::class);
    }
}
