<?php

namespace App\Models;

use App\Enum\Currency;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class TradeBot extends Model
{
    protected $guarded = [];

    protected $casts = [
        'asset_pairs' => 'array', // JSON → array
        'parameters'  => 'array',
        'features'  => 'array',
        'currency' => Currency::class
    ];
    protected static function booted()
    {
        static::creating(function ($trade) {
            $trade->uuid = Str::uuid();
        });
    }
}
