<?php

namespace App\Models;

use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class Swap extends Model
{
    protected $guarded = [];

    protected $casts = [
        'swapped_at' => 'datetime',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    protected static function booted()
    {
        static::creating(function ($swap) {
            $swap->uuid = Str::uuid();
        });
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function fromMarket()
    {
        return $this->belongsTo(Market::class, 'from_market_id');
    }

    public function toMarket()
    {
        return $this->belongsTo(Market::class, 'to_market_id');
    }

    public function statusBadge(): string
    {
        return match ($this->status) {
            'completed' => 'badge bg-success-subtle text-success fs-12 p-1',
            'pending' => 'badge bg-warning-subtle text-warning fs-12 p-1',
            'failed' => 'badge bg-danger-subtle text-danger fs-12 p-1',
            default => 'badge bg-secondary-subtle text-secondary fs-12 p-1',
        };
    }

    public function statusLabel(): string
    {
        return ucfirst($this->status);
    }
}
