<?php

namespace App\Models;

use App\Enum\SignalAction;
use App\Enum\SignalDuration;
use App\Enum\SignalType;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class Signal extends Model
{
    protected $guarded = [];

    protected $casts = [
        'duration' => SignalDuration::class,
        'type' => SignalType::class,
        'action' => SignalAction::class
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (empty($model->uuid)) {
                $model->uuid = (string) Str::uuid();
            }
        });
    }

    public function market()
    {
        return $this->belongsTo(Market::class);
    }
}
