<?php

namespace App\Models;

use App\Enum\IsolatedMarginRequestStatus;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class IsolatedMarginRequest extends Model
{
    protected $fillable = [
        'uuid',
        'user_id',
        'wallet_id',
        'amount',
        'status',
        'proof',
        'admin_note',
        'reviewed_at',
    ];

    protected $casts = [
        'status' => IsolatedMarginRequestStatus::class,
        'reviewed_at' => 'datetime',
    ];

    protected static function booted()
    {
        static::creating(function ($model) {
            $model->uuid = Str::uuid();
        });
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function wallet()
    {
        return $this->belongsTo(Wallet::class);
    }

    public function isPending(): bool
    {
        return $this->status === IsolatedMarginRequestStatus::PENDING;
    }

    public function isApproved(): bool
    {
        return $this->status === IsolatedMarginRequestStatus::APPROVED;
    }

    public function isDeclined(): bool
    {
        return $this->status === IsolatedMarginRequestStatus::DECLINED;
    }

    public function getRouteKeyName()
    {
        return 'uuid';
    }
}
