<?php

namespace App\Models;

use App\Enum\CopyTradeRequestStatus;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class CopyTradeRequest extends Model
{
    protected $fillable = [
        'uuid',
        'trader_id',
        'user_id',
        'status',
        'is_automated_started',
        'admin_note',
        'reviewed_at',
    ];

    protected $casts = [
        'status' => CopyTradeRequestStatus::class,
        'reviewed_at' => 'datetime',
    ];

    protected static function booted()
    {
        static::creating(function ($model) {
            $model->uuid = Str::uuid();
        });
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function trader()
    {
        return $this->belongsTo(Trader::class);
    }

    public function isPending(): bool
    {
        return $this->status === CopyTradeRequestStatus::PENDING;
    }

    public function isApproved(): bool
    {
        return $this->status === CopyTradeRequestStatus::APPROVED;
    }

    public function isDeclined(): bool
    {
        return $this->status === CopyTradeRequestStatus::DECLINED;
    }
}
