<?php

namespace App\Models;

use App\Enum\PlanType;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class CopyTradePlan extends Model
{
    protected $guarded = [];

    protected $casts = [
        'type' => PlanType::class,
        'minimum' => 'decimal:2',
        'maximum' => 'decimal:2',
        'daily_profit' => 'decimal:2',
        'commission_percentage' => 'decimal:2',
        'features' => 'array',
        'daily_profit_duration' => 'integer',
        'trades_per_day' => 'integer',
        'daily_profit_multiplication' => 'integer'
    ];

    public function getRouteKeyName()
    {
        return 'uuid';
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (empty($model->uuid)) {
                $model->uuid = (string) Str::uuid();
            }
        });
    }

    public function userCopyTradePlans()
    {
        return $this->hasMany(UserCopyTradePlan::class);
    }
}
