<?php

namespace App\Models;

use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class CopyTradeParticipant extends Model
{
    protected $guarded = [];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    protected static function booted()
    {
        static::creating(function ($model) {
            $model->uuid = Str::uuid();
        });
    }

    public function copyTrade()
    {
        return $this->belongsTo(CopyTrade::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
