<?php

namespace App\Models;

use App\Enum\CopyTradeStatus;
use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;

class CopyTrade extends Model
{
    protected $guarded = [];

    protected $casts = [
        'status' => CopyTradeStatus::class,
        'started_at' => 'datetime',
        'ended_at' => 'datetime',
    ];

    protected static function booted()
    {
        static::creating(function ($model) {
            $model->uuid = Str::uuid();
        });
    }

    public function participants()
    {
        return $this->hasMany(CopyTradeParticipant::class);
    }

    public function trader()
    {
        return $this->belongsTo(Trader::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class, 'copy_trade_participants')
            ->withPivot(['invested_amount', 'profit_loss', 'is_active'])
            ->withTimestamps();
    }

    public function isActive(): bool
    {
        return $this->status === CopyTradeStatus::ACTIVE;
    }

    public function isCompleted(): bool
    {
        return $this->status === CopyTradeStatus::COMPLETED;
    }

    public function isCancelled(): bool
    {
        return $this->status === CopyTradeStatus::CANCELLED;
    }
}
