<?php

namespace App\Livewire\Auth;

use App\Models\User;
use App\Enum\UserRole;
use Livewire\Component;
use Illuminate\Support\Str;
use App\Mail\PasswordResetLink;
use App\Models\PasswordResetToken;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class ForgotPassword extends Component
{
    public $email;

    public function forgotPassword()
    {
        $this->validate([
            'email' => ['required', 'email', 'max:255'],
        ]);

        try {
            DB::beginTransaction();

            $user = User::where('role', UserRole::USER->value)->where('email', $this->email)->first();

            if (!$user) {
                DB::rollBack();
                session()->flash('error', 'No user found with this email.');
                return;
            }

            $token = Str::random(64);

            PasswordResetToken::updateOrCreate(
                ['email' => $user->email],
                [
                    'token' => $token,
                    'created_at' => now()
                ]
            );

            $passwordResetToken = PasswordResetToken::where('email', $user->email)->first();

            $passwordResetLink = route('password.reset', [
                'token' => $passwordResetToken->token,
                'email' => $passwordResetToken->email
            ]);

            Mail::to($user->email)->queue(new PasswordResetLink($user, $passwordResetLink));

            DB::commit();

            session()->flash('success', 'Password reset link has been sent to your email. Please check your inbox.');
            return;
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error($e->getMessage());
            session()->flash('error', config('app.messages.error'));
            return;
        }
    }
    public function render()
    {
        return view('livewire.auth.forgot-password');
    }
}
