<?php

namespace App\Jobs;

use App\Models\Newsletter;
use App\Mail\NewsletterMail;
use App\Models\NewsletterSubscriber;
use Illuminate\Support\Facades\Mail;
use Illuminate\Foundation\Queue\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendNewsletterJob implements ShouldQueue
{
    use Queueable;

    public Newsletter $newsletter;

    /**
     * Create a new job instance.
     */
    public function __construct(Newsletter $newsletter)
    {
        $this->newsletter = $newsletter;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        NewsletterSubscriber::query()
            ->select('email')
            ->chunk(100, function ($subscribers) {
                foreach ($subscribers as $subscriber) {
                    Mail::to($subscriber->email)
                        ->queue(new NewsletterMail($this->newsletter, $subscriber->email));
                }
            });

        $this->newsletter->update([
            'sent_at' => now(),
        ]);
    }
}
